IF NOT OBJECT_ID('UFD_RC_CREDIARIO_EXTRATO') IS NULL
	BEGIN
		DROP FUNCTION UFD_RC_CREDIARIO_EXTRATO
	END
GO

CREATE FUNCTION [dbo].[UFD_RC_CREDIARIO_EXTRATO]
                                          (
                                                  @CD_EMP                      INT,
                                                  @CD_CTR_FECHA                VARCHAR(5000)
                                          ) RETURNS @RC_RETORNO TABLE ( CD_EMP INT, CD_CLI INT, RZ_CLI NVARCHAR(100), CGC_CPF NVARCHAR(20), NR_CARTAO NVARCHAR(50), END_CLI NVARCHAR(100), BAIRRO NVARCHAR(50), CEP NVARCHAR(10), DS_CID NVARCHAR(50), UF NVARCHAR(5), DT_LIM_CRED DATETIME, VLR_LIM_CRED MONEY, VLR_LIM_PARC_CRED MONEY, VLR_LIM_FAT_CRED MONEY, VLR_DEB_CRED MONEY, VLR_DEB_PARC_CRED MONEY, VLR_DEB_FAT_CRED MONEY, PERC_MULTA_ATRASO MONEY, PERC_JUROS_ATRASO MONEY, PERC_JUROS_FIN MONEY, PERC_JUROS_REFIN MONEY, VLR_FECHA_ANT MONEY, CD_CTR_FECHA_ANT INT, CD_CTR_FECHA INT, NR_FATURA VARCHAR(20), DT_LANCTO DATETIME, VLR_LANCTO MONEY, PARC_CRED INT, QT_PARC_VD_CRED INT, TP_CRED_DEB_LANCTO INT, HIST_LANCTO NVARCHAR(100), DT_VENCTO DATETIME, VLR_FECHA MONEY, VLR_MINIMO MONEY, CD_BARRA NVARCHAR(60), CD_FILIAL INT, NR_ECF INT, CD_CTR_PARC INT, CD_CX INT, NM_COMPRADOR VARCHAR(100)) AS
        BEGIN
                DECLARE
                        @MOV_FECHA TABLE ( CD_EMP INT, CD_CLI INT, CD_CTR_FECHA INT, CD_CTR_FECHA_ANT INT, DT_LANCTO DATETIME, VLR_LANCTO MONEY, PARC_CRED INT, QT_PARC_VD_CRED INT, TP_CRED_DEB_LANCTO INT, HIST_LANCTO VARCHAR(100), DT_VENCTO DATETIME, VLR_FECHA MONEY, VLR_MINIMO MONEY, CD_FILIAL INT, NR_ECF INT, CD_CTR_PARC INT, CD_CX INT, NM_COMPRADOR VARCHAR(100))
                                              
                        
                        INSERT
                        INTO   @MOV_FECHA
                        SELECT RC_CREDIARIO_FECHA.CD_EMP                    ,
                               RC_CREDIARIO_FECHA.CD_CLI                    ,
                               RC_CREDIARIO_FECHA.CD_CTR_FECHA              ,
                               RC_CREDIARIO_FECHA.CD_CTR_FECHA_ANT          ,
                               RC_CREDIARIO_PARC.DT_LANC_CRED  AS DT_LANCTO ,
                               RC_CREDIARIO_PARC.VLR_PARC_CRED AS VLR_LANCTO,
                               RC_CREDIARIO_PARC.PARC_CRED                  ,
                               RC_CREDIARIO_PARC.QT_PARC_VD_CRED            ,
                               1 AS TP_CRED_DEB_LANCTO                      ,
                               (
                                      CASE
                                             WHEN RC_CREDIARIO_PARC.CD_TP_LANC = 6
                                             THEN 'SALDO ANTERIOR ATUALIZADO FATURA NR. ' + RIGHT(REPLICATE('0', 6) + CAST(RC_CREDIARIO_FECHA.CD_CTR_FECHA_ANT AS VARCHAR), 6)
                                             ELSE RC_CREDIARIO_TP_LANC.DS_TP_LANC
                                      END) AS HIST_LANCTO        ,
                               RC_CREDIARIO_FECHA.DT_VENCTO      ,
                               RC_CREDIARIO_FECHA.VLR_FECHA      ,
                               RC_CREDIARIO_FECHA.VLR_MINIMO     ,
                               RC_CREDIARIO_PARC_PDV_VD.CD_FILIAL,
                               PDV_VD.NR_ECF                     ,
                               RC_CREDIARIO_PARC.CD_CTR          ,
                               PDV_VD.CD_CX,
							   PDV_VD.NM_COMPRADOR
                        FROM   RC_CREDIARIO_FECHA
                               INNER JOIN RC_CLI_CREDIARIO
                               ON     RC_CREDIARIO_FECHA.CD_EMP = RC_CLI_CREDIARIO.CD_EMP
                               AND    RC_CREDIARIO_FECHA.CD_CLI = RC_CLI_CREDIARIO.CD_CLI
                               INNER JOIN RC_CREDIARIO_PARC_RC_CREDIARIO_FECHA
                               ON     RC_CREDIARIO_FECHA.CD_CTR_FECHA = RC_CREDIARIO_PARC_RC_CREDIARIO_FECHA.CD_CTR_FECHA
                               INNER JOIN RC_CREDIARIO_PARC
                               ON     RC_CREDIARIO_PARC_RC_CREDIARIO_FECHA.CD_CTR = RC_CREDIARIO_PARC.CD_CTR
                               INNER JOIN RC_CREDIARIO_TP_LANC
                               ON     RC_CREDIARIO_PARC.CD_TP_LANC = RC_CREDIARIO_TP_LANC.CD_TP_LANC
                               LEFT JOIN RC_CREDIARIO_PARC_PDV_VD
                               ON     RC_CREDIARIO_PARC.CD_EMP = RC_CREDIARIO_PARC_PDV_VD.CD_EMP
                               AND    RC_CREDIARIO_PARC.CD_CTR = RC_CREDIARIO_PARC_PDV_VD.CD_CTR
                               LEFT JOIN PDV_VD
                               ON     RC_CREDIARIO_PARC_PDV_VD.CD_EMP    = PDV_VD.CD_EMP
                               AND    RC_CREDIARIO_PARC_PDV_VD.CD_FILIAL = PDV_VD.CD_FILIAL
                               AND    RC_CREDIARIO_PARC_PDV_VD.CD_VD     = PDV_VD.CD_VD
                        WHERE  RC_CREDIARIO_FECHA.CD_EMP                 = @CD_EMP
                        AND    RC_CREDIARIO_FECHA.CD_CTR_FECHA IN
                               (SELECT ID
                               FROM    UFD_PRM_IN_STRING(@CD_CTR_FECHA)
                               )

                       UNION ALL

                       SELECT   RC_CREDIARIO_FECHA.CD_EMP                 ,
                                RC_CREDIARIO_FECHA.CD_CLI                 ,
                                RC_CREDIARIO_FECHA.CD_CTR_FECHA           ,
                                RC_CREDIARIO_FECHA.CD_CTR_FECHA_ANT       ,
                                RC_CRED.DT_PAG                            ,
                                SUM(RC_CRED.VL_PGTO)                                                                 AS VLR_LANCTO        ,
                                1                                                                                    AS PARC_CRED         ,
                                1                                                                                    AS QT_PARC_VD_CRED   ,
                                0                                                                                    AS TP_CRED_DEB_LANCTO,
                                'PGTO FATURA NR: ' + RIGHT(REPLICATE('0', 6) + CAST(RC_DEB.NR_FATURA AS VARCHAR), 6) AS HIST_LANCTO       ,
                                RC_CREDIARIO_FECHA.DT_VENCTO                                                                              ,
                                RC_CREDIARIO_FECHA.VLR_FECHA                                                                              ,
                                RC_CREDIARIO_FECHA.VLR_MINIMO                                                                             ,
                                RC_CRED.CD_FILIAL                                                                                         ,
                                0 AS NR_ECF                                                                                               ,
                                0 AS CD_CTR_PARC                                                                                          ,
                                0 AS CD_CX,
								'' AS NM_COMPRADOR
                       FROM     RC_CREDIARIO_FECHA
                                INNER JOIN RC_CREDIARIO_FECHA_RC_DEB
                                ON       RC_CREDIARIO_FECHA.CD_CTR_FECHA_ANT = RC_CREDIARIO_FECHA_RC_DEB.CD_CTR_FECHA
                                INNER JOIN RC_DEB
                                ON       RC_CREDIARIO_FECHA_RC_DEB.CD_EMP    = RC_DEB.CD_EMP
                                AND      RC_CREDIARIO_FECHA_RC_DEB.CD_EMP    = RC_DEB.CD_FILIAL
                                AND      RC_CREDIARIO_FECHA_RC_DEB.CD_RC_DEB = RC_DEB.CD_RC_DEB
                                INNER JOIN RC_PGTO_PDV_RC_CRED
                                ON       RC_DEB.CD_EMP    = RC_PGTO_PDV_RC_CRED.CD_EMP
                                AND      RC_DEB.CD_EMP    = RC_PGTO_PDV_RC_CRED.CD_FILIAL
                                AND      RC_DEB.CD_RC_DEB = RC_PGTO_PDV_RC_CRED.CD_RC_DEB
                                INNER JOIN RC_CRED
                                ON       RC_PGTO_PDV_RC_CRED.CD_EMP     = RC_CRED.CD_EMP
                                AND      RC_PGTO_PDV_RC_CRED.CD_FILIAL  = RC_CRED.CD_FILIAL
                                AND      RC_PGTO_PDV_RC_CRED.CD_RC_DEB  = RC_CRED.CD_RC_DEB
                                AND      RC_PGTO_PDV_RC_CRED.CD_DP_LANC = RC_CRED.CD_DP_LANC
                       WHERE    RC_CREDIARIO_FECHA.CD_EMP               = @CD_EMP
                       AND      RC_CREDIARIO_FECHA.CD_CTR_FECHA IN
                                (SELECT ID
                                FROM    UFD_PRM_IN_STRING(@CD_CTR_FECHA)
                                )
                       GROUP BY RC_CREDIARIO_FECHA.CD_EMP          ,
                                RC_CRED.CD_FILIAL                  ,
                                RC_CREDIARIO_FECHA.CD_CLI          ,
                                RC_CREDIARIO_FECHA.CD_CTR_FECHA    ,
                                RC_CREDIARIO_FECHA.CD_CTR_FECHA_ANT,
                                RC_CRED.DT_PAG                     ,
                                RC_CREDIARIO_FECHA.DT_VENCTO       ,
                                RC_CREDIARIO_FECHA.VLR_FECHA       ,
                                RC_CREDIARIO_FECHA.VLR_MINIMO      ,
                                RC_DEB.NR_FATURA
                                
                       INSERT
                       INTO   @RC_RETORNO
                       SELECT   RC_CLI.CD_EMP                                      ,
                                RC_CLI.CD_CLI                                      ,
                                RC_CLI.RZ_CLI                                      ,
                                RC_CLI.CGC_CPF                                     ,
                                RC_CLI_FIDELI_CARTAO.NR_CARTAO                     ,
                                RC_CLI.END_CLI + ' NR.: ' + CONVERT(VARCHAR(10),RC_CLI.NUMERO) ,
                                RC_CLI.BAIRRO                                      ,
                                RC_CLI.CEP                                         ,
                                GLB_CID.DS_CID                                     ,
                                GLB_CID.UF                                         ,
                                CONVERT(VARCHAR(10), GETDATE(), 101) AS DT_LIM_CRED,
                                RC_CLI_CREDIARIO.VLR_LIM_CRED                      ,
                                RC_CLI_CREDIARIO.VLR_LIM_PARC_CRED                 ,
                                RC_CLI_CREDIARIO.VLR_LIM_FAT_CRED                  ,
                                RC_CLI_CREDIARIO.VLR_DEB_CRED                      ,
                                RC_CLI_CREDIARIO.VLR_DEB_PARC_CRED                 ,
                                RC_CLI_CREDIARIO.VLR_DEB_FAT_CRED                  ,
                                RC_MDL_VENDA.PERC_JUROS_MULTA                      ,
                                RC_MDL_VENDA.PERC_JUROS_ATRASO                     ,
                                RC_MDL_VENDA.PERC_JUROS_FIN                        ,
                                RC_MDL_VENDA.PERC_JUROS_REFIN                      ,
                                FECHA_ANT.VLR_FECHA    AS VLR_FECHA_ANT               ,
                                FECHA_ANT.CD_CTR_FECHA AS CD_CTR_FECHA_ANT            ,
                                MOV_FECHA.CD_CTR_FECHA                                ,
                                RC_DEB.NR_FATURA                                      ,
                                MOV_FECHA.DT_LANCTO                                   ,
                                MOV_FECHA.VLR_LANCTO                                  ,
                                MOV_FECHA.PARC_CRED                                   ,
                                MOV_FECHA.QT_PARC_VD_CRED                             ,
                                MOV_FECHA.TP_CRED_DEB_LANCTO                          ,
                                MOV_FECHA.HIST_LANCTO                                 ,
                                RC_DEB.DT_VENCTO                                      ,
                                MOV_FECHA.VLR_FECHA                                   ,
                                MOV_FECHA.VLR_MINIMO                                  ,
                                RC_DEB.CD_BARRAS_BOLETA                               ,
                                MOV_FECHA.CD_FILIAL                                   ,
                                MOV_FECHA.NR_ECF                                      ,
                                MOV_FECHA.CD_CTR_PARC                                 ,
                                MOV_FECHA.CD_CX,
								MOV_FECHA.NM_COMPRADOR
                       FROM     @MOV_FECHA MOV_FECHA
                                INNER JOIN RC_CLI
                                ON       MOV_FECHA.CD_EMP = RC_CLI.CD_EMP
                                AND      MOV_FECHA.CD_CLI = RC_CLI.CD_CLI
                                INNER JOIN RC_CLI_CREDIARIO
                                ON       RC_CLI.CD_EMP = RC_CLI_CREDIARIO.CD_EMP
                                AND      RC_CLI.CD_CLI = RC_CLI_CREDIARIO.CD_CLI
                                LEFT JOIN RC_MDL_VENDA
                                ON       RC_CLI_CREDIARIO.CD_EMP    = RC_MDL_VENDA.CD_EMP
                                AND      RC_CLI_CREDIARIO.CD_MDL_VD = RC_MDL_VENDA.CD_MDL_VD
                                LEFT JOIN GLB_CID
                                ON       RC_CLI.CD_CID = GLB_CID.CD_CID
                                LEFT JOIN RC_CLI_FIDELI_CARTAO
                                ON       RC_CLI.CD_EMP = RC_CLI_FIDELI_CARTAO.CD_EMP
                                AND      RC_CLI.CD_CLI = RC_CLI_FIDELI_CARTAO.CD_CLI
                                LEFT JOIN RC_CREDIARIO_FECHA FECHA_ANT
                                ON       MOV_FECHA.CD_CTR_FECHA_ANT = FECHA_ANT.CD_CTR_FECHA
                                LEFT JOIN RC_CREDIARIO_FECHA_RC_DEB
                                ON       MOV_FECHA.CD_CTR_FECHA = RC_CREDIARIO_FECHA_RC_DEB.CD_CTR_FECHA
                                LEFT JOIN RC_DEB
                                ON       RC_CREDIARIO_FECHA_RC_DEB.CD_EMP    = RC_DEB.CD_EMP
                                AND      RC_CREDIARIO_FECHA_RC_DEB.CD_FILIAL = RC_DEB.CD_FILIAL
                                AND      RC_CREDIARIO_FECHA_RC_DEB.CD_RC_DEB = RC_DEB.CD_RC_DEB
                       ORDER BY MOV_FECHA.CD_CTR_FECHA,
                                DT_LANCTO             ,
                                PARC_CRED             ,
                                TP_CRED_DEB_LANCTO DESC                         
                        
                        RETURN
              END


